//OHSAT GAMES TUTORIAL: MEGALAGA 4 BONUS: Enemy Movement & Input
//There's a reference to Rolling in the OHSAT Tutorial for this lesson.
//It is your duty to make the reference to Weird Al and not Fred Durst or something equally terrible.   

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>

// Constants
#define LEFT_EDGE 0
#define RIGHT_EDGE 320

#define MAX_ENEMIES 6
#define MAX_BULLETS 3

#define ANIM_STRAIGHT 0
#define ANIM_MOVE 1
#define ANIM_DIE 7

// Entity struct
typedef struct {
	int x, y, w, h;
	int velx, vely;
	int health;
	Sprite* sprite;
	char name[8];
} Entity;

// Globals
int offset = 0;
u16 enemiesLeft = 0;

Entity player = {0}, player_2 = {0};
Entity enemies_top[MAX_ENEMIES];
Entity enemies_bottom[MAX_ENEMIES];

Entity bullets_p1[MAX_BULLETS];
Entity bullets_p2[MAX_BULLETS];
u16 bulletsOnScreenP1 = 0;
u16 bulletsOnScreenP2 = 0;

// Function declarations
void killEntity(Entity* e);
void reviveEntity(Entity* e);
void positionEnemies();
void positionPlayers();
void positionBullets();
void shootBullet(Entity* shooter, Entity* bulletArray, u16* bulletCount, SpriteDefinition* spriteDef);
void myJoyHandler(u16 joy, u16 changed, u16 state);

int main()
{
    JOY_init();
    JOY_setEventHandler(&myJoyHandler);

    SYS_disableInts();
    VDP_loadTileSet(background.tileset, 1, DMA);
    PAL_setPalette(PAL1, background.palette->data, DMA);
    PAL_setPalette(PAL2, background.palette->data, DMA);
    VDP_setScrollingMode(HSCROLL_PLANE, VSCROLL_PLANE);
    PAL_setColor(34,RGB24_TO_VDPCOLOR(0x0078f8));
    SYS_enableInts();

    SPR_init();

    // Initialize players
    player = (Entity){152, 192, 16, 16, 0, 0, 1, SPR_addSprite(&ship, 152, 192, TILE_ATTR(PAL1, 0, FALSE, FALSE)), "P1"};
    player_2 = (Entity){100, 192, 16, 16, 0, 0, 1, SPR_addSprite(&ship1, 100, 192, TILE_ATTR(PAL1, 0, FALSE, FALSE)), "P2"};

    // Background fill
    for (int i = 0; i < 1280; i++) {
        int thex = i % 40;
        int they = i / 40;
        int val = (random() % 10) + 1;
        if(val > 3) val = 1;
        VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, 0, 0, val), thex, they);
    }

    // Create enemies
    for(int i = 0; i < MAX_ENEMIES; i++) {
        enemies_top[i] = (Entity){i*32, 32, 16, 16, 1, 0, 1, SPR_addSprite(&ship, i*32, 32, TILE_ATTR(PAL2, 0, TRUE, FALSE)), ""};
        sprintf(enemies_top[i].name, "E1_%d", i);
        enemiesLeft++;

        enemies_bottom[i] = (Entity){320 - (i*32), 64, 16, 16, -1, 0, 1, SPR_addSprite(&nemo_sprite, 320 - (i*32), 64, TILE_ATTR(PAL2, 0, TRUE, FALSE)), ""};
        sprintf(enemies_bottom[i].name, "E2_%d", i);
        SPR_setAnim(enemies_bottom[i].sprite, ANIM_DIE);
        enemiesLeft++;
    }

    // Initialize bullets
    for (int i = 0; i < MAX_BULLETS; i++) {
        bullets_p1[i] = (Entity){0, -10, 8, 8, 0, 0, 0, SPR_addSprite(&bullet, 0, -10, TILE_ATTR(PAL1, 0, FALSE, FALSE)), ""};
        bullets_p2[i] = (Entity){0, -10, 8, 8, 0, 0, 0, SPR_addSprite(&bullet1, 0, -10, TILE_ATTR(PAL1, 0, FALSE, FALSE)), ""};
        sprintf(bullets_p1[i].name, "Bu1_%d", i);
        sprintf(bullets_p2[i].name, "Bu2_%d", i);
    }

    while (1) {
        VDP_setVerticalScroll(BG_B, offset -= 2);
        if (offset <= -256) offset = 0;

        positionPlayers();
        positionEnemies();
        positionBullets();

        SPR_update();
        SYS_doVBlankProcess();
    }

    return 0;
}

// Player input
void myJoyHandler(u16 joy, u16 changed, u16 state) {
    Entity* p = (joy == JOY_1) ? &player : &player_2;
    Entity* bulletArray = (joy == JOY_1) ? bullets_p1 : bullets_p2;
    u16* bulletCount = (joy == JOY_1) ? &bulletsOnScreenP1 : &bulletsOnScreenP2;
    SpriteDefinition* bulletSprite = (joy == JOY_1) ? &bullet : &bullet1;

    if (state & BUTTON_RIGHT) {
        p->velx = 2;
        SPR_setAnim(p->sprite, ANIM_MOVE);
        SPR_setHFlip(p->sprite, TRUE);
    } else if (state & BUTTON_LEFT) {
        p->velx = -2;
        SPR_setAnim(p->sprite, ANIM_MOVE);
        SPR_setHFlip(p->sprite, FALSE);
    } else {
        if ((changed & BUTTON_LEFT) || (changed & BUTTON_RIGHT)) {
            p->velx = 0;
            SPR_setAnim(p->sprite, ANIM_STRAIGHT);
        }
    }

    if ((state & BUTTON_B) && (changed & BUTTON_B)) {
        shootBullet(p, bulletArray, bulletCount, bulletSprite);
    }
}

// Move players
void positionPlayers() {
    // Player 1
    player.x += player.velx;
    if(player.x < LEFT_EDGE) player.x = LEFT_EDGE;
    if(player.x + player.w > RIGHT_EDGE) player.x = RIGHT_EDGE - player.w;
    SPR_setPosition(player.sprite, player.x, player.y);

    // Player 2
    player_2.x += player_2.velx;
    if(player_2.x < LEFT_EDGE) player_2.x = LEFT_EDGE;
    if(player_2.x + player_2.w > RIGHT_EDGE) player_2.x = RIGHT_EDGE - player_2.w;
    SPR_setPosition(player_2.sprite, player_2.x, player_2.y);
}

// Move enemies
void positionEnemies() {
    for(int i = 0; i < MAX_ENEMIES; i++) {
        Entity* e1 = &enemies_top[i];
        if(e1->health > 0) {
            e1->x += e1->velx;
            if(e1->x < LEFT_EDGE || (e1->x + e1->w) > RIGHT_EDGE) e1->velx = -e1->velx;
            SPR_setPosition(e1->sprite, e1->x, e1->y);
        }

        Entity* e2 = &enemies_bottom[i];
        if(e2->health > 0) {
            e2->x += e2->velx;
            if(e2->x < LEFT_EDGE || (e2->x + e2->w) > RIGHT_EDGE) e2->velx = -e2->velx;
            SPR_setPosition(e2->sprite, e2->x, e2->y);
        }
    }
}

// Fire bullet from a player
void shootBullet(Entity* shooter, Entity* bulletArray, u16* bulletCount, SpriteDefinition* spriteDef) {
    if(*bulletCount < MAX_BULLETS) {
        for(int i = 0; i < MAX_BULLETS; i++) {
            Entity* b = &bulletArray[i];
            if(b->health == 0) {
                b->x = shooter->x + 4;
                b->y = shooter->y;
                b->vely = -3;
                reviveEntity(b);
                SPR_setPosition(b->sprite, b->x, b->y);
                (*bulletCount)++;
                break;
            }
        }
    }
}

// Move bullets and deactivate off-screen ones
void positionBullets() {
    for(int i = 0; i < MAX_BULLETS; i++) {
        Entity* b1 = &bullets_p1[i];
        if(b1->health > 0) {
            b1->y += b1->vely;
            if(b1->y + b1->h < 0) {
                killEntity(b1);
                bulletsOnScreenP1--;
            } else {
                SPR_setPosition(b1->sprite, b1->x, b1->y);
            }
        }

        Entity* b2 = &bullets_p2[i];
        if(b2->health > 0) {
            b2->y += b2->vely;
            if(b2->y + b2->h < 0) {
                killEntity(b2);
                bulletsOnScreenP2--;
            } else {
                SPR_setPosition(b2->sprite, b2->x, b2->y);
            }
        }
    }
}

// Entity utilities
void killEntity(Entity* e) {
    e->health = 0;
    SPR_setVisibility(e->sprite, HIDDEN);
}
void reviveEntity(Entity* e) {
    e->health = 1;
    SPR_setVisibility(e->sprite, VISIBLE);
}


/////////////////CHANGE LOG//////////////////

/*

✅ Summary of Code Merger
🧩 1. Combined Features from Both Lessons
Merged single-player functionality from Lesson 5 with two-player setup from Bonus Lesson 5.

Preserved background scrolling, enemy movement, and bullet mechanics.

Integrated both waves of enemies: top and bottom rows.

🚀 2. Two-Player Support
Player 1 uses ship sprite and fires bullet.

Player 2 uses ship1 sprite and fires bullet1.

Each player can move independently with their own controls (JOY_1 and JOY_2).

🔫 3. Bullet System
Created two bullet arrays:

bullets_p1[MAX_BULLETS] for Player 1.

bullets_p2[MAX_BULLETS] for Player 2.

Each bullet type uses a unique sprite (bullet or bullet1).

Bullet movement and lifecycle (shoot, update position, hide off-screen) handled separately for each player.

👾 4. Enemies
Top row: moves right-to-left with ship sprite.

Bottom row: moves left-to-right with nemo_sprite, using animation frame ANIM_DIE.

🎮 5. Input Handling
Shared myJoyHandler() supports both players:

JOY_1: Player 1 movement and shooting.

JOY_2: Player 2 movement and shooting.

Detects directional input and Button B to shoot.

🛠️ 6. Utility Functions
killEntity() and reviveEntity() manage entity visibility and state.

Cleanly reuses logic for positioning and updating all entities.

*/

////////////////////NOTES////////////////////

/*

New Code Additions Summarization

🧱 1. New Global Variables and Data Structures

#define MAX_BULLETS 3

Entity bullets_p1[MAX_BULLETS];
Entity bullets_p2[MAX_BULLETS];
u16 bulletsOnScreenP1 = 0;
u16 bulletsOnScreenP2 = 0;
Purpose: Adds bullet support for each player.

bullets_p1 and bullets_p2: Arrays of Entity structs that represent bullets fired by Player 1 and Player 2, respectively.

MAX_BULLETS: Maximum bullets per player allowed on screen at once.

bulletsOnScreenP1 / bulletsOnScreenP2: Counters to prevent exceeding bullet limits.

🛠️ 2. Bullet Initialization

for (int i = 0; i < MAX_BULLETS; i++) {
    bullets_p1[i] = (Entity){0, -10, 8, 8, 0, 0, 0, SPR_addSprite(&bullet, 0, -10, TILE_ATTR(PAL1, 0, FALSE, FALSE)), ""};
    bullets_p2[i] = (Entity){0, -10, 8, 8, 0, 0, 0, SPR_addSprite(&bullet1, 0, -10, TILE_ATTR(PAL1, 0, FALSE, FALSE)), ""};
    sprintf(bullets_p1[i].name, "Bu1_%d", i);
    sprintf(bullets_p2[i].name, "Bu2_%d", i);
}
Purpose: Prepares and hides bullet sprites off-screen.

x = 0, y = -10: Off-screen position until fired.

SPR_addSprite(): Creates bullet sprites using bullet for Player 1 and bullet1 for Player 2.

🧠 3. Bullet Firing Function

void shootBullet(Entity* shooter, Entity* bulletArray, u16* bulletCount, SpriteDefinition* spriteDef) {
    if(*bulletCount < MAX_BULLETS) {
        for(int i = 0; i < MAX_BULLETS; i++) {
            Entity* b = &bulletArray[i];
            if(b->health == 0) {
                b->x = shooter->x + 4;
                b->y = shooter->y;
                b->vely = -3;
                reviveEntity(b);
                SPR_setPosition(b->sprite, b->x, b->y);
                (*bulletCount)++;
                break;
            }
        }
    }
}
Purpose: Shoots a bullet from a player.

Parameters:

shooter: Either player or player_2.

bulletArray: Reference to the shooter's bullet array.

bulletCount: Pointer to current count of bullets on screen.

spriteDef: Sprite definition to use (bullet or bullet1).

Reuses dead bullet (health == 0) to avoid dynamic memory allocation.

🎮 4. Input Update in myJoyHandler()

if ((state & BUTTON_B) && (changed & BUTTON_B)) {
    shootBullet(p, bulletArray, bulletCount, bulletSprite);
}
Purpose: Handles the shooting action when the B button is pressed.

Dynamically determines which player is pressing (JOY_1 or JOY_2), and passes correct bullet array and sprite type.

🚀 5. Bullet Movement in positionBullets()

for(int i = 0; i < MAX_BULLETS; i++) {
    Entity* b1 = &bullets_p1[i];
    if(b1->health > 0) {
        b1->y += b1->vely;
        if(b1->y + b1->h < 0) {
            killEntity(b1);
            bulletsOnScreenP1--;
        } else {
            SPR_setPosition(b1->sprite, b1->x, b1->y);
        }
    }

    Entity* b2 = &bullets_p2[i];
    if(b2->health > 0) {
        b2->y += b2->vely;
        if(b2->y + b2->h < 0) {
            killEntity(b2);
            bulletsOnScreenP2--;
        } else {
            SPR_setPosition(b2->sprite, b2->x, b2->y);
        }
    }
}
Purpose: Updates bullet positions every frame.

Bullets move upward (vely = -3).

If bullet goes off-screen (top), it’s "killed" and removed from active count.

🧼 6. Utility Functions (from Lesson 5)

void killEntity(Entity* e) {
    e->health = 0;
    SPR_setVisibility(e->sprite, HIDDEN);
}

void reviveEntity(Entity* e) {
    e->health = 1;
    SPR_setVisibility(e->sprite, VISIBLE);
}
Purpose: Manage entity visibility and lifecycle.

Used when firing a bullet (reviveEntity) and when it leaves screen (killEntity).

✅ Result of These Additions
The merged game now supports:

Two-player independent movement and shooting.

Custom bullet sprites per player.

Separate bullet tracking and reuse (efficient memory use).

Smooth gameplay with vertical bullet movement.

*/

/////////EXPERIMENTATION IDEAS///////////////

/*

We're going to do another merger to try and get both player ships to fire. 
Can we add something a little extra as well? 

Answer: Yes, we can! Let's make the bullet sprite for the other player look unique!

*/

///////////ERROR HANDLING////////////////////
/*

*/